$(function () {
    try {
        $("#startDate").datepicker({
            defaultDate: "endDateday",
            changeMonth: true,
            changeYear: true,
            numberOfMonths: 1,
            onClose: function (selectedDate) {
                $("#endDate").datepicker("option", "minDate", selectedDate);
            }
        });
    } catch (err) {
        //not all datepickers exist on the non-research request page
    }

    try {
        $("#endDate").datepicker({
            defaultDate: "endDateday",
            changeMonth: true,
            changeYear: true,
            numberOfMonths: 1,
            onClose: function (selectedDate) {
                $("#startDate").datepicker("option", "maxDate", selectedDate);
            }
        });
    } catch (err) {
        //not all datepickers exist on the non-research request page
    }

    $("#datepicker").datepicker({});

    try {
        $("#irbExpDate").datepicker({
            changeMonth: true,
            changeYear: true,
            minDate: new Date(),
            maxDate: '+5y',
            onClose: function (selectedDate) {
                var currDate = $.datepicker.formatDate('mm/dd/yy', new Date());
                if (selectedDate < currDate) {
                    $("#warning").append("The IRB Expiration Date has expired"); //for review page
                } else {
                    $("#warning").html(""); //for review page
                }
            }
        });
    } catch (err) {
        //not all datepickers exist on the non-research request page
    }
      
    try {
        $("#expectedIRBSubmissionDate").datepicker({
            changeMonth: true,
            changeYear: true,
            minDate: new Date(),
            maxDate: '+1y',
            onClose: function (selectedDate) {
                var currDate = $.datepicker.formatDate('mm/dd/yy', new Date());
                if (selectedDate < currDate) {
                    $("#warning").append("The Expected IRB Submission Date has expired"); //for review page
                } else {
                    $("#warning").html(""); //for review page
                }
            }
        });
    } catch (err) {
        //not all datepickers exist on the request page
    }

    try {
        $("#dateOfBirth").datepicker({
            changeMonth: true,
            changeYear: true
        });
    } catch (err) {
        //not all datepickers exist on the non-research request page
    }
});

jQuery(function ($) {
    try {
        $("#startDate").mask("99/99/9999");
        $("#endDate").mask("99/99/9999");
    } catch (err) {
        //not all datepickers exist on the non-research request page
    }

    try {
        $("#irbExpDate").mask("99/99/9999");
        $("#dateOfBirth").mask("99/99/9999");
    } catch (err) {
        //not all datepickers exist on the non-research request page
    }
    
    try {
        $("#expectedIRBSubmissionDate").mask("99/99/9999");
    } catch (err) {
        //not all datepickers exist on the research request page
    }
});

$("#datepicker").datepicker({ maxDate: new Date() });
//call this function whenever the datepicker value changes (clear the old message)
function verifyIRBExpirationDate() {

    var irbExpDate = $("#irbExpDate");
    if (irbExpDate != undefined && irbExpDate != null) {	//non-research-request currently doesn't require IRB

        $("#warning").html(""); //clear the error message

        var irbExpDateValue = irbExpDate.datepicker("getDate"); //get the selected date
        if ($.datepicker != undefined && irbExpDateValue != null) {

            var currDate = $.datepicker.formatDate('mm/dd/yy', new Date());
            if (irbExpDateValue < currDate) {
                $("#warning").append("The IRB Expiration Date has expired"); //display the error message
            } else {
                $("#warning").html(""); //clear the error message
            }

        } else {
            $("#warning").html(""); //clear the error message
        }
    } //end if

};


function verifyDateForExpiration(date, message) {

   // var irbExpDate = $("#irbExpDate");
    if (date != undefined && date != null) {	//non-research-request currently doesn't require IRB

        $("#warning").html(""); //clear the error message

        var dateValue = date.datepicker("getDate"); //get the selected date
        if ($.datepicker != undefined && dateValue != null) {

            var currDate = $.datepicker.formatDate('mm/dd/yy', new Date());
            if (dateValue < currDate) {
                $("#warning").append(message); //display the error message
            } else {
                $("#warning").html(""); //clear the error message
            }

        } else {
            $("#warning").html(""); //clear the error message
        }
    } //end if

};

